<?php
header('Content-Type: application/json');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

$response = [
    'success' => true,
    'timestamp' => date('Y-m-d H:i:s'),
    'files' => []
];

// Verificar se os arquivos existem
$files_to_check = [
    'admin/dashboard.html',
    'login.html',
    'index.html'
];

foreach ($files_to_check as $file) {
    $response['files'][$file] = [
        'exists' => file_exists($file),
        'size' => file_exists($file) ? filesize($file) : 0,
        'modified' => file_exists($file) ? date('Y-m-d H:i:s', filemtime($file)) : null
    ];
}

// Verificar se o dashboard.html contém o novo design
if (file_exists('admin/dashboard.html')) {
    $content = file_get_contents('admin/dashboard.html');
    $response['dashboard_check'] = [
        'has_inter_font' => strpos($content, 'Inter') !== false,
        'has_fontawesome' => strpos($content, 'font-awesome') !== false,
        'has_professional_design' => strpos($content, 'Dashboard Profissional') !== false,
        'has_loading_indicator' => strpos($content, 'loadingIndicator') !== false,
        'file_size_kb' => round(strlen($content) / 1024, 2)
    ];
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>