<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Log da requisição
error_log("Método: " . $_SERVER['REQUEST_METHOD']);
error_log("Content-Type: " . ($_SERVER['CONTENT_TYPE'] ?? 'não definido'));

$input = json_decode(file_get_contents('php://input'), true);
error_log("Input recebido: " . print_r($input, true));

try {
    require_once 'config/database.php';
    require_once 'includes/functions.php';
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($input['action']) && $input['action'] === 'login_admin') {
        $email = $input['email'] ?? '';
        $senha = $input['senha'] ?? '';
        
        error_log("Tentativa de login - Email: $email, Senha: $senha");
        
        if (empty($email) || empty($senha)) {
            echo json_encode(['success' => false, 'message' => 'Email e senha são obrigatórios']);
            exit;
        }
        
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ? AND ativo = TRUE");
        $stmt->execute([$email]);
        $admin = $stmt->fetch();
        
        error_log("Admin encontrado: " . ($admin ? 'SIM' : 'NÃO'));
        
        if ($admin) {
            error_log("Hash no banco: " . $admin['senha']);
            error_log("Verificação senha: " . (password_verify($senha, $admin['senha']) ? 'VÁLIDA' : 'INVÁLIDA'));
        }
        
        if (!$admin || !password_verify($senha, $admin['senha'])) {
            echo json_encode(['success' => false, 'message' => 'Email ou senha incorretos']);
            exit;
        }
        
        unset($admin['senha']);
        
        echo json_encode([
            'success' => true,
            'message' => 'Login realizado com sucesso',
            'admin' => $admin
        ]);
        
    } else {
        echo json_encode(['success' => false, 'message' => 'Ação inválida']);
    }
    
} catch (Exception $e) {
    error_log("Erro: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Erro interno: ' . $e->getMessage()]);
}
?>