<?php
// Simple test to debug the connection issue
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Log all incoming data
error_log("=== TEST CONNECTION DEBUG ===");
error_log("Method: " . $_SERVER['REQUEST_METHOD']);
error_log("Headers: " . json_encode(getallheaders()));

$input = file_get_contents('php://input');
error_log("Raw input: " . $input);

$decoded = json_decode($input, true);
error_log("Decoded input: " . json_encode($decoded));

try {
    require_once 'config/database.php';
    require_once 'includes/functions.php';
    
    $db = new Database();
    $conn = $db->connect();
    
    // Test database connection
    $stmt = $conn->query("SELECT 1 as test");
    $result = $stmt->fetch();
    
    if ($result) {
        error_log("Database connection: OK");
        
        // Test motorista exists
        $stmt = $conn->prepare("SELECT id, nome, disponivel FROM motoristas WHERE id = 1");
        $stmt->execute();
        $motorista = $stmt->fetch();
        
        if ($motorista) {
            error_log("Motorista found: " . json_encode($motorista));
            
            // Test update
            $stmt = $conn->prepare("UPDATE motoristas SET disponivel = ? WHERE id = ?");
            $updateResult = $stmt->execute([1, 1]);
            
            if ($updateResult) {
                error_log("Update successful, rows affected: " . $stmt->rowCount());
                
                jsonResponse([
                    'success' => true,
                    'message' => 'Conexão testada com sucesso',
                    'debug' => [
                        'method' => $_SERVER['REQUEST_METHOD'],
                        'input' => $decoded,
                        'motorista' => $motorista,
                        'update_rows' => $stmt->rowCount()
                    ]
                ]);
            } else {
                error_log("Update failed");
                jsonResponse(['success' => false, 'message' => 'Falha no update'], 500);
            }
        } else {
            error_log("Motorista not found");
            jsonResponse(['success' => false, 'message' => 'Motorista não encontrado'], 404);
        }
    } else {
        error_log("Database test failed");
        jsonResponse(['success' => false, 'message' => 'Falha no teste de banco'], 500);
    }
    
} catch (Exception $e) {
    error_log("Exception: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => 'Erro: ' . $e->getMessage()], 500);
}
?>