const CACHE_NAME = 'rideshare-cache-v1';
const ASSETS_TO_CACHE = [
  '/plataforma/',
  '/plataforma/index.html',
  '/plataforma/motorista/index.html',
  '/plataforma/passageiro/index.html',
  '/plataforma/manifest.json'
];

self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(ASSETS_TO_CACHE))
  );
  self.skipWaiting();
});

self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(keys => Promise.all(
      keys.filter(k => k !== CACHE_NAME).map(k => caches.delete(k))
    ))
  );
  self.clients.claim();
});

self.addEventListener('fetch', event => {
  const request = event.request;

  // Only handle GET navigation and same-origin requests
  if (request.method !== 'GET') return;

  event.respondWith(
    caches.match(request).then(cached => {
      if (cached) return cached;
      return fetch(request).then(response => {
        if (!response || response.status !== 200 || response.type === 'opaque') return response;
        const responseClone = response.clone();
        caches.open(CACHE_NAME).then(cache => cache.put(request, responseClone));
        return response;
      }).catch(() => {
        // Fallback for navigation requests: serve index.html
        if (request.mode === 'navigate') {
          return caches.match('/plataforma/index.html');
        }
      });
    })
  );
});
