import React from 'react';
import { Zap } from 'lucide-react';

const SurgeHexagons = ({ map, isVisible }) => {
  const surgeAreas = [
    { 
      id: 1, 
      lat: -23.550520, 
      lng: -46.633308, 
      multiplier: '1.8-2.2x', 
      level: 'high',
      color: 'bg-orange-500'
    },
    { 
      id: 2, 
      lat: -23.545520, 
      lng: -46.628308, 
      multiplier: '1.5-1.9x', 
      level: 'medium',
      color: 'bg-yellow-500'
    },
    { 
      id: 3, 
      lat: -23.555520, 
      lng: -46.638308, 
      multiplier: '1.3-1.7x', 
      level: 'low',
      color: 'bg-green-500'
    },
    { 
      id: 4, 
      lat: -23.560520, 
      lng: -46.643308, 
      multiplier: '1.6-2.0x', 
      level: 'high',
      color: 'bg-orange-500'
    },
    { 
      id: 5, 
      lat: -23.540520, 
      lng: -46.623308, 
      multiplier: '1.1-1.5x', 
      level: 'low',
      color: 'bg-green-500'
    },
    { 
      id: 6, 
      lat: -23.565520, 
      lng: -46.648308, 
      multiplier: '1.4-1.8x', 
      level: 'medium',
      color: 'bg-yellow-500'
    }
  ];

  if (!isVisible) return null;

  return (
    <>
      {surgeAreas.map((area) => (
        <div
          key={area.id}
          className={`
            absolute z-10 pointer-events-none
            ${area.color} bg-opacity-80 text-white
            px-2 py-1 rounded-lg text-xs font-semibold
            flex items-center gap-1 shadow-lg
            animate-pulse-slow
          `}
          style={{
            // Posicionamento seria calculado baseado na projeção do mapa
            // Por simplicidade, usando posições fixas para demonstração
            top: `${20 + (area.id * 8)}%`,
            left: `${15 + (area.id * 12)}%`,
          }}
        >
          <Zap size={12} />
          <span>{area.multiplier}</span>
        </div>
      ))}
    </>
  );
};

export default SurgeHexagons;