@echo off
echo 📱 RideShare Driver - Gerador de APK
echo =====================================

echo.
echo ✅ Verificando Java...
java -version
if %errorlevel% neq 0 (
    echo ❌ Java não encontrado!
    echo Instale Java 17 ou superior
    pause
    exit /b 1
)

echo.
echo 🔨 Gerando build de produção...
call npm run build
if %errorlevel% neq 0 (
    echo ❌ Erro no build!
    pause
    exit /b 1
)

echo.
echo 🔄 Sincronizando com Capacitor...
call npx cap sync
if %errorlevel% neq 0 (
    echo ❌ Erro na sincronização!
    pause
    exit /b 1
)

echo.
echo 📱 Gerando APK...
cd android
call gradlew assembleDebug
if %errorlevel% neq 0 (
    echo ❌ Erro ao gerar APK!
    echo Verifique se tem Java 17 ou superior
    pause
    exit /b 1
)

echo.
echo ✅ APK gerado com sucesso!
echo 📁 Localização: android\app\build\outputs\apk\debug\app-debug.apk
echo.
echo 📱 Para instalar no dispositivo:
echo 1. Ative "Fontes desconhecidas" no Android
echo 2. Transfira o APK para o dispositivo
echo 3. Instale o arquivo APK
echo 4. Conceda permissões de localização
echo.
pause