<?php
// Script para gerar ícones PNG automaticamente

// Função para criar PNG simples com gradiente
function createIconPNG($width, $height, $filename) {
    $image = imagecreatetruecolor($width, $height);
    
    // Cores do gradiente (roxo-vermelho)
    $color1 = imagecolorallocate($image, 255, 107, 53);   // #FF6B35 (Laranja)
    $color2 = imagecolorallocate($image, 255, 255, 255); // Branco
    $white = imagecolorallocate($image, 255, 255, 255);
    
    // Preencher com gradiente simulado
    for ($i = 0; $i < $height; $i++) {
        $ratio = $i / $height;
        $r = intval(255 * (1 - $ratio) + 255 * $ratio);
        $g = intval(107 * (1 - $ratio) + 255 * $ratio);
        $b = intval(53 * (1 - $ratio) + 255 * $ratio);
        $color = imagecolorallocate($image, $r, $g, $b);
        imageline($image, 0, $i, $width, $i, $color);
    }
    
    // Desenhar ícone de carro simples (quadrado com círculos)
    $centerX = $width / 2;
    $centerY = $height / 2;
    $size = min($width, $height) / 3;
    
    // Corpo do carro (retângulo)
    imagefilledrectangle($image, 
        $centerX - $size, $centerY - $size/2,
        $centerX + $size, $centerY + $size/2,
        $white
    );
    
    // Rodas (círculos)
    imagefilledellipse($image, 
        $centerX - $size/2, $centerY + $size/2,
        $size/2, $size/2,
        $white
    );
    imagefilledellipse($image, 
        $centerX + $size/2, $centerY + $size/2,
        $size/2, $size/2,
        $white
    );
    
    // Salvar arquivo
    imagepng($image, $filename);
    imagedestroy($image);
}

// Criar ícones
createIconPNG(192, 192, __DIR__ . '/icon-192.png');
createIconPNG(512, 512, __DIR__ . '/icon-512.png');

echo "✅ Ícones criados com sucesso!";
?>
