<?php
// Script para criar uma conta de teste de motorista

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/includes/functions.php';

try {
    $db = new Database();
    $conn = $db->connect();

    // Dados do motorista de teste
    $email = 'motorista@teste.com';
    $senha = '123456';
    $nome = 'Motorista Teste';
    $telefone = '11999999999';
    $cpf = '12345678901';

    // Verificar se já existe
    $stmt = $conn->prepare("SELECT id FROM motoristas WHERE email = ?");
    $stmt->execute([$email]);
    
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'Motorista já existe']);
        exit;
    }

    // Hash da senha
    $senha_hash = hashPassword($senha);

    // Inserir motorista
    $stmt = $conn->prepare("
        INSERT INTO motoristas (
            nome, email, telefone, cpf, senha,
            veiculo_marca, veiculo_modelo, veiculo_placa, veiculo_cor, veiculo_ano,
            status, disponivel, latitude, longitude
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    $stmt->execute([
        $nome,
        $email,
        $telefone,
        $cpf,
        $senha_hash,
        'Toyota',
        'Corolla',
        'ABC1234',
        'Preto',
        2023,
        'ativo',
        0,
        -23.550520,
        -46.633308
    ]);

    $motorista_id = $conn->lastInsertId();

    echo json_encode([
        'success' => true,
        'message' => 'Motorista de teste criado com sucesso!',
        'motorista_id' => $motorista_id,
        'email' => $email,
        'senha' => $senha
    ], JSON_PRETTY_PRINT);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
