<?php
require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->connect();
    
    echo "<h2>Verificando Motorista de Teste</h2>";
    
    // Verificar se existe o motorista
    $stmt = $conn->prepare("SELECT * FROM motoristas WHERE email = ?");
    $stmt->execute(['andre.rj.tj@gmail.com']);
    $motorista = $stmt->fetch();
    
    if ($motorista) {
        echo "<h3>✅ Motorista encontrado:</h3>";
        echo "<pre>";
        print_r($motorista);
        echo "</pre>";
    } else {
        echo "<h3>❌ Motorista não encontrado</h3>";
        echo "<p>Criando motorista de teste...</p>";
        
        // Criar motorista de teste
        $senha_hash = password_hash('123456', PASSWORD_DEFAULT);
        
        $stmt = $conn->prepare("
            INSERT INTO motoristas (
                nome, email, telefone, senha, cpf, cnh, data_nascimento,
                categoria_veiculo_id, placa_veiculo, modelo_veiculo, 
                cor_veiculo, ano_veiculo, status
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        $result = $stmt->execute([
            'André Motorista',
            'andre.rj.tj@gmail.com',
            '(11) 99999-9999',
            $senha_hash,
            '123.456.789-00',
            '12345678901',
            '1990-01-01',
            2, // categoria carro popular
            'ABC-1234',
            'Honda Civic',
            'Prata',
            2020,
            'ativo'
        ]);
        
        if ($result) {
            echo "<h3>✅ Motorista criado com sucesso!</h3>";
            $motorista_id = $conn->lastInsertId();
            echo "<p>ID: $motorista_id</p>";
        } else {
            echo "<h3>❌ Erro ao criar motorista</h3>";
        }
    }
    
    // Verificar categorias de veículo
    echo "<h3>Categorias de Veículo:</h3>";
    $stmt = $conn->query("SELECT * FROM categorias_veiculo LIMIT 5");
    $categorias = $stmt->fetchAll();
    
    if ($categorias) {
        echo "<ul>";
        foreach ($categorias as $cat) {
            echo "<li>ID: {$cat['id']} - {$cat['nome']}</li>";
        }
        echo "</ul>";
    } else {
        echo "<p>❌ Nenhuma categoria encontrada</p>";
    }
    
} catch (Exception $e) {
    echo "<h3>❌ Erro:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>