<?php
try {
    require_once 'config/database.php';
    
    echo "=== VERIFICAÇÃO DO BANCO DE DADOS ===\n\n";
    
    $db = new Database();
    $conn = $db->connect();
    
    echo "✓ Conexão com banco estabelecida\n\n";
    
    // Verificar se as tabelas existem
    $tables = ['administradores', 'usuarios', 'motoristas', 'corridas', 'categorias_veiculo'];
    
    foreach ($tables as $table) {
        $stmt = $conn->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "✓ Tabela '$table' existe\n";
        } else {
            echo "✗ Tabela '$table' NÃO existe\n";
        }
    }
    
    echo "\n=== VERIFICAÇÃO DO ADMIN ===\n";
    
    // Verificar admin
    $stmt = $conn->query("SELECT COUNT(*) as total FROM administradores");
    $result = $stmt->fetch();
    echo "Total de administradores: " . $result['total'] . "\n";
    
    $stmt = $conn->prepare("SELECT * FROM administradores WHERE email = ?");
    $stmt->execute(['admin@rideshare.com']);
    $admin = $stmt->fetch();
    
    if ($admin) {
        echo "✓ Admin padrão encontrado:\n";
        echo "  - ID: " . $admin['id'] . "\n";
        echo "  - Nome: " . $admin['nome'] . "\n";
        echo "  - Email: " . $admin['email'] . "\n";
        echo "  - Nível: " . $admin['nivel'] . "\n";
        echo "  - Ativo: " . ($admin['ativo'] ? 'SIM' : 'NÃO') . "\n";
        echo "  - Hash: " . substr($admin['senha'], 0, 20) . "...\n";
        
        // Testar senha
        $senha_teste = 'admin123';
        $valida = password_verify($senha_teste, $admin['senha']);
        echo "  - Senha 'admin123' válida: " . ($valida ? 'SIM' : 'NÃO') . "\n";
        
    } else {
        echo "✗ Admin padrão NÃO encontrado\n";
        echo "Criando admin padrão...\n";
        
        $hash = password_hash('admin123', PASSWORD_BCRYPT);
        $stmt = $conn->prepare("
            INSERT INTO administradores (nome, email, senha, nivel, ativo) 
            VALUES (?, ?, ?, ?, ?)
        ");
        
        if ($stmt->execute(['Administrador', 'admin@rideshare.com', $hash, 'super', 1])) {
            echo "✓ Admin criado com sucesso!\n";
        } else {
            echo "✗ Erro ao criar admin\n";
        }
    }
    
    echo "\n=== VERIFICAÇÃO DAS CATEGORIAS ===\n";
    $stmt = $conn->query("SELECT COUNT(*) as total FROM categorias_veiculo");
    $result = $stmt->fetch();
    echo "Total de categorias: " . $result['total'] . "\n";
    
} catch (Exception $e) {
    echo "ERRO: " . $e->getMessage() . "\n";
    echo "Verifique se:\n";
    echo "1. O MySQL está rodando\n";
    echo "2. O banco 'rideshare_platform' foi criado\n";
    echo "3. As credenciais em config/database.php estão corretas\n";
}
?>