<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/functions.php';

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

// Atualizar Localização do Motorista
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'atualizar_localizacao') {
    $motorista_id = $input['motorista_id'] ?? '';
    $latitude = $input['latitude'] ?? '';
    $longitude = $input['longitude'] ?? '';
    
    if (empty($motorista_id) || empty($latitude) || empty($longitude)) {
        jsonResponse(['success' => false, 'message' => 'Dados incompletos'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("
            UPDATE motoristas 
            SET latitude = ?, longitude = ?, ultima_localizacao = NOW()
            WHERE id = ?
        ");
        $stmt->execute([$latitude, $longitude, $motorista_id]);
        
        jsonResponse(['success' => true, 'message' => 'Localização atualizada']);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao atualizar localização'], 500);
    }
}

// Alterar Disponibilidade
if ($method === 'POST' && isset($input['action']) && $input['action'] === 'alterar_disponibilidade') {
    $motorista_id = $input['motorista_id'] ?? '';
    $disponivel = $input['disponivel'] ?? false;
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("UPDATE motoristas SET disponivel = ? WHERE id = ?");
        $stmt->execute([$disponivel ? 1 : 0, $motorista_id]);
        
        $status = $disponivel ? 'online' : 'offline';
        registrarLog('motorista', $motorista_id, 'alterar_disponibilidade', "Status alterado para $status");
        
        jsonResponse(['success' => true, 'message' => 'Disponibilidade atualizada']);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao atualizar disponibilidade'], 500);
    }
}

// Obter Saldo
if ($method === 'GET' && isset($_GET['action']) && $_GET['action'] === 'obter_saldo') {
    $motorista_id = $_GET['motorista_id'] ?? '';
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $stmt = $conn->prepare("SELECT saldo, total_corridas FROM motoristas WHERE id = ?");
        $stmt->execute([$motorista_id]);
        $dados = $stmt->fetch();
        
        jsonResponse([
            'success' => true,
            'saldo' => $dados['saldo'],
            'total_corridas' => $dados['total_corridas']
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao obter saldo'], 500);
    }
}

// Obter Estatísticas do Dia
if ($method === 'GET' && isset($_GET['action']) && $_GET['action'] === 'obter_estatisticas_dia') {
    $motorista_id = $_GET['motorista_id'] ?? '';
    
    if (empty($motorista_id)) {
        jsonResponse(['success' => false, 'message' => 'ID do motorista é obrigatório'], 400);
    }
    
    try {
        $db = new Database();
        $conn = $db->connect();
        
        $hoje = date('Y-m-d');
        
        // Buscar corridas do dia
        $stmt = $conn->prepare("
            SELECT 
                COUNT(*) as corridas_hoje,
                COALESCE(SUM(valor_motorista), 0) as ganho_hoje
            FROM corridas 
            WHERE motorista_id = ? 
            AND DATE(solicitada_em) = ?
            AND status = 'concluida'
        ");
        $stmt->execute([$motorista_id, $hoje]);
        $stats = $stmt->fetch();
        
        jsonResponse([
            'success' => true,
            'corridas_hoje' => $stats['corridas_hoje'] ?? 0,
            'ganho_hoje' => $stats['ganho_hoje'] ?? 0
        ]);
        
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao obter estatísticas'], 500);
    }
}

// Obter última localização do motorista
if ($method === 'GET' && isset($_GET['action']) && $_GET['action'] === 'obter_localizacao') {
    $motorista_id = $_GET['motorista_id'] ?? '';

    if (empty($motorista_id)) {
        jsonResponse(['success' => false, 'message' => 'ID do motorista é obrigatório'], 400);
    }

    try {
        $db = new Database();
        $conn = $db->connect();

        $stmt = $conn->prepare("SELECT latitude, longitude, ultima_localizacao FROM motoristas WHERE id = ?");
        $stmt->execute([$motorista_id]);
        $row = $stmt->fetch();

        if ($row) {
            jsonResponse([
                'success' => true,
                'latitude' => $row['latitude'],
                'longitude' => $row['longitude'],
                'ultima_localizacao' => $row['ultima_localizacao']
            ]);
        } else {
            jsonResponse(['success' => false, 'message' => 'Motorista não encontrado'], 404);
        }
    } catch (Exception $e) {
        jsonResponse(['success' => false, 'message' => 'Erro ao obter localização'], 500);
    }
}

jsonResponse(['success' => false, 'message' => 'Ação inválida'], 400);
