# Solução para Problema de Login do Admin

## Problema
O login do painel administrativo não está funcionando com as credenciais padrão.

## Credenciais Padrão
- **Email:** admin@rideshare.com
- **Senha:** 123456

## Passos para Resolver

### 1. Verificar se o Servidor está Rodando
- Certifique-se que o Apache/Nginx e MySQL estão rodando
- Acesse `http://localhost/test_server.php` para verificar se o PHP está funcionando

### 2. Verificar o Banco de Dados
- Execute o arquivo `check_database.php` no navegador: `http://localhost/check_database.php`
- Este arquivo irá:
  - Verificar a conexão com o banco
  - Verificar se as tabelas existem
  - Verificar se o admin padrão existe
  - Criar o admin se não existir

### 3. Testar o Login
- Acesse `http://localhost/test_login.html`
- Este arquivo irá testar:
  - Se o servidor PHP está respondendo
  - Se a API de login está funcionando
  - Se as credenciais estão corretas

### 4. Verificar Logs de Erro
- Verifique os logs do Apache/PHP para erros
- No Windows com XAMPP: `C:\xampp\apache\logs\error.log`

### 5. Problemas Comuns e Soluções

#### Erro 404 - Arquivo não encontrado
- Verifique se você está acessando a URL correta
- Certifique-se que os arquivos estão na pasta correta do servidor web

#### Erro de Conexão com Banco
- Verifique as credenciais em `config/database.php`
- Certifique-se que o MySQL está rodando
- Verifique se o banco `rideshare_platform` foi criado

#### Hash de Senha Inválido
- Execute `check_database.php` para recriar o admin com hash correto

#### Erro de CORS
- Certifique-se que está acessando via `http://localhost` e não `file://`

### 6. Configuração Manual do Admin

Se nada funcionar, execute este SQL diretamente no MySQL:

```sql
USE rideshare_platform;

-- Deletar admin existente (se houver)
DELETE FROM administradores WHERE email = 'admin@rideshare.com';

-- Criar novo admin
INSERT INTO administradores (nome, email, senha, nivel, ativo) VALUES
('Administrador', 'admin@rideshare.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'super', 1);
```

### 7. URLs para Testar

1. **Servidor básico:** `http://localhost/test_server.php`
2. **Verificação do banco:** `http://localhost/check_database.php`
3. **Teste de login:** `http://localhost/test_login.html`
4. **Painel admin:** `http://localhost/admin/index.html`

### 8. Debug do JavaScript

O painel admin agora tem logs detalhados no console do navegador:
1. Abra o painel admin
2. Pressione F12 para abrir as ferramentas de desenvolvedor
3. Vá na aba "Console"
4. Tente fazer login e veja os logs detalhados

## Próximos Passos

Após resolver o problema de login:
1. Acesse o painel admin
2. Verifique se o dashboard carrega corretamente
3. Teste as outras funcionalidades (usuários, motoristas, etc.)

## Suporte

Se o problema persistir, verifique:
1. Versão do PHP (deve ser 7.4+)
2. Extensões PHP necessárias (PDO, MySQL)
3. Permissões de arquivo
4. Configurações do servidor web